/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.Version;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.simulation.OnlineTestTool;
import java.awt.Window;
import java.util.Collections;
import javax.swing.JOptionPane;

public class ChangeDeviceStateAction
extends LogoAction {
    public ChangeDeviceStateAction() {
        this.putValue("Name", "changeDeviceState");
        this.putValue("textKey", "extra.transfer.changeDeviceState");
        this.putValue("SmallIcon", Global.getIcon("ChangeDeviceState.gif"));
        this.disabledContextVector = Collections.singletonList(OnlineTestTool.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doIt() {
        Window window = ((LogoComfort)this.getOwner()).getApplicationSurface().getWindow();
        boolean result = true;
        DataTransfer dt = null;
        try {
            dt = DataTransfer.openConnection(true);
            Hardware hw = dt.getHardware();
            if (hw.supports("transmissionPossible")) {
                int deviceState = dt.getDeviceState();
                result = deviceState == 1 || deviceState == 32 ? this.handleChangeToStop(window, dt) : this.handleChangeToRun(window, dt);
            } else {
                JOptionPane.showMessageDialog(window, Language.getString("changeDeviceState.functionNotAvailable", "Function not available", hw.getLocalizedName(false)));
            }
        }
        catch (ExceptionAlreadyHandledException ex) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            if (dt != null) {
                dt.closePort();
                dt = null;
            }
        }
        if (!result) {
            new LogoError(window, "changeDeviceState.changeFailed", "Failed to change mode.").display();
        }
        return result;
    }

    private boolean handleChangeToRun(Window window, DataTransfer dt) throws TransmissionFailedException {
        int rv = JOptionPane.showConfirmDialog(window, Language.getString("changeDeviceState.changeToRun", "Change to RUN?"), Language.getString("hardware.family.name", "Device"), 0);
        if (rv == 0) {
            return dt.sendStateCommand(24);
        }
        return true;
    }

    private boolean handleChangeToStop(Window window, DataTransfer dt) throws TransmissionFailedException {
        int rv = JOptionPane.showConfirmDialog(window, Language.getString("changeDeviceState.changeToStop", "Change to STOP?"), Language.getString("hardware.family.name", "Device"), 0);
        if (rv == 0) {
            return dt.sendStateCommand(18);
        }
        return true;
    }

    public synchronized void setEnabled(boolean newValue) {
        if (Version.getCurrentVersion().isDemoVersion()) {
            super.setEnabled(false);
        } else {
            super.setEnabled(newValue);
        }
    }
}

